/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.table3.JCCellRange;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.TextPositioningWrapper;
import jclass.table3.bean.TextPositioningCellRenderer;

public class TextPositioningEditor
extends SeriesEditor
implements ActionListener,
ItemListener {
    private Choice choiceAlignmentH;
    private Choice choiceAlignmentV;
    private final String LEFT = "left";
    private final String MIDDLE = "middle";
    private final String RIGHT = "right";
    private final String TOP = "top";
    private final String BOTTOM = "bottom";

    public void setValue(Object object) {
        if (object == null) {
            object = new TextPositioningWrapper("(all all TOPLEFT)");
        }
        this.tableView.setTextPositioning((TextPositioningWrapper)object);
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getTextPositioning();
    }

    public String getAsText() {
        return "\"" + this.tableView.fromSeries(0) + "\"";
    }

    public String getJavaInitializationString() {
        return "new jclass.table3.TextPositioningWrapper(" + this.getAsText() + ")";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceAlignmentH) || object.equals(this.choiceAlignmentV)) {
            String string = this.choiceAlignmentH.getSelectedItem();
            int n = string.equals("left") ? 0 : (string.equals("middle") ? 1 : 2);
            String string2 = this.choiceAlignmentV.getSelectedItem();
            int n2 = string2.equals("top") ? 0 : (string2.equals("middle") ? 1 : 2);
            this.tableView.setAlignment(jCCellRange, this.getAlignment(n, n2));
            this.support.firePropertyChange("textPositioning", null, this.getValue());
        }
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("textPositioning", null, this.getValue());
        if (jCCellRange == null) {
            return;
        }
        int n = this.tableView.getAlignment(jCCellRange.start_row, jCCellRange.start_column);
        this.choiceAlignmentH.select(this.getHorizAlignment(n));
        this.choiceAlignmentV.select(this.getVertAlignment(n));
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new TextPositioningCellRenderer(this);
    }

    protected Component makePropertyPanel() {
        this.choiceAlignmentH = new Choice();
        this.choiceAlignmentH.addItem("left");
        this.choiceAlignmentH.addItem("middle");
        this.choiceAlignmentH.addItem("right");
        this.choiceAlignmentV = new Choice();
        this.choiceAlignmentV.addItem("top");
        this.choiceAlignmentV.addItem("middle");
        this.choiceAlignmentV.addItem("bottom");
        GroupPanel groupPanel = new GroupPanel("Alignment");
        FlowLayout flowLayout = new FlowLayout(0, 10, 0);
        flowLayout.setVgap(6);
        groupPanel.setLayout(flowLayout);
        groupPanel.add(new Label("Horizontal"));
        groupPanel.add(this.choiceAlignmentH);
        groupPanel.add(new Label("Vertical"));
        groupPanel.add(this.choiceAlignmentV);
        this.choiceAlignmentH.addItemListener(this);
        this.choiceAlignmentV.addItemListener(this);
        return groupPanel;
    }

    private String getHorizAlignment(int n) {
        switch (n) {
            case 0: 
            case 3: 
            case 6: {
                return "left";
            }
            case 1: 
            case 4: 
            case 7: {
                return "middle";
            }
            case 2: 
            case 5: 
            case 8: {
                return "right";
            }
        }
        return "left";
    }

    private String getVertAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "top";
            }
            case 3: 
            case 4: 
            case 5: {
                return "middle";
            }
            case 6: 
            case 7: 
            case 8: {
                return "bottom";
            }
        }
        return "top";
    }

    private int getAlignment(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 7;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 8;
                    }
                }
            }
        }
        return 0;
    }
}

